<title>Edit Profile -https://bestleearning.com/</title>
@extends('user.layouts.master')
@section('css')
 <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/argon.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/myapp.css" type="text/css">
    <link rel="stylesheet" href="https://www.powerworkerearn.com/resources/css/bttn.css" type="text/css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <style>
    /* Custom styles for user profile page */
    .page-title-box {
        background: linear-gradient(to right, #6a11cb, #2575fc);
        padding: 20px;
        border-radius: 10px;
        color: #fff;
        text-align: center;
        margin-bottom: 30px;
    }
    .directory-card {
        background-color: #ffffff;
        border: 1px solid #e9ecef;
        border-radius: 10px;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        overflow: hidden;
    }
    .avatar-lg {
        width: 100px;
        height: 100px;
    }
    .flex-grow-1 h5 {
        font-size: 24px;
        color: #343a40;
        margin-bottom: 5px;
    }
    .flex-grow-1 p {
        margin: 0;
        font-size: 14px;
        color: #6c757d;
    }
    .form-group label {
        font-weight: 600;
        color: #495057;
    }
    .form-control {
        border-radius: 10px;
        padding: 10px;
    }
    .btnn-primary {
        background: #6a11cb;
        color: #fff;
        border: none;
        padding: 10px 20px;
        border-radius: 50px;
        font-size: 16px;
        transition: background 0.3s;
    }
    .btnn-primary:hover {
        background: #2575fc;
    }
    .img-thumbnail {
        border: 2px solid #dee2e6;
    }
    @media (max-width: 768px) {
        .avatar-lg {
            width: 80px;
            height: 80px;
        }
        .flex-grow-1 h5 {
            font-size: 20px;
        }
    }
</style>
@endsection
@section('user-content')

<form action="{{ route('user.profile.update', Auth::user()->id) }}" method="POST" enctype="multipart/form-data" id="updateForm">
	@csrf
    <div class="row justify-content-md-center">
        <div class="col-lg-8">
            <div class="card mt-2">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 text-center">
    						@if (file_exists(Auth::user()->image))
                                <img alt="" class="rounded-circle border-dark profile-image" src="{{ URL::to(Auth::user()->image) }}" width="150px" height="150px" id="profileDisplay">
                            @else
                                <img class="rounded-circle border-dark profile-image" src="{{ asset('frontend/img/user.png') }}" alt="User Image" width="150px" height="150px" id="displayImage">
                            @endif
                            <div id="imageContainer"style="margin-top: 10px" class="text-right">
                               <input type="file" class="form-control hidden-input" name="image" id="profilePicture" accept="image/x-png,image/jpg,image/jpeg" onchange="readURL()" lang="en">
                                    <small class="text-danger" id="file-error"></small>
                                    <img id="imagePreview" src="#" alt="Image Preview" style="display: none; max-width: 200px; margin-top: 10px;">


                                <label class="custom-file-label-drop" for="profilePicture">
                                    <i class="fas fa-camera"></i> Select new image
                                </label>
                            </div>
                       </div>
                   </div>
                   <br><!--<button type="submit" class="btn btn-outline-info" onclick="submitForm('image')">Update Image</button>--><button type="submit" name="update_image" class="btn btn-outline-info bttn">Update Image</button>
               </div>

                <div class="card">
                    <div class="card-header">
                        <div class="row align-items-center">
                            <div class="col-8">
                                <h3 class="mb-0">Edit profile </h3>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <h6 class="heading-small text-muted mb-4">Account information</h6>
                            <div class="pl-lg-4">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="name" class="form-label">Full Name</label>
                                            <input class="form-control" type="text" name="name" placeholder="name" value="{{ Auth::user()->name }}" @if(Auth::user()->premium_status == 1) readonly @endif required>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <marquee bgcolor="transparent" style="padding: 5px;border-radius: 5px;border: 1px solid black;" behavior="scroll">
                                            <a style="font-size:15px; color: black;">
                                                <i class="fe fe-link me-2" aria-hidden="true"></i>Don't share your Email with anyone
                                            </a>
                                        </marquee>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
    										<label for="email" class="form-label">Email Address</label>
    										<input class="form-control" type="email" readonly value="{{ Auth::user()->email }}" placeholder="email">
    									</div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                         <div class="form-group">
    										<label for="age" class="form-label">Age</label>
    										<textarea class="form-control" name="age" placeholder="Enter your age">{{ session('user_age') }}</textarea>
    									</div>
                                    </div>
                                    <div class="col-lg-6">
    									<div class="form-group">
    										<label for="country" class="form-label">Country</label>
    										<input class="form-control" type="text" value="{{ country(Auth::user()->country) }}" readonly placeholder="Country">
    									</div>
    								</div>
    							</div>
    						</div>
    							<hr class="my-4">
    							<!-- Description -->
    							<h6 class="heading-small text-muted mb-4">About me</h6>
    							<div class="pl-lg-4">
    							    <div class="form-group">
                                        <label for="phone" class="form-label">Bio</label>
                                        <input class="form-control" type="text" value="{{ Auth::user()->phone }}" name="phone" placeholder="Enter your bio">
                                    </div>
    							</div>
    							<button type="submit" name="" class="btn btn-outline-info bttn">Update Information</button>
    				</div>
    	    	</div>
				<div class="card">
					<div class="card-body">
						 <h6 class="heading-small text-muted mb-4">Account Password</h6>
							<div class="pl-lg-4">
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label for="password" class="form-label">New Password</label>
											<input class="form-control" type="password" name="password" placeholder="Password">
										</div>
									</div>
								</div>
							</div>
							<!--<button type="submit" class="btn btn-outline-info" onclick="submitForm('password')">Update Password</button>-->
							<button type="submit" name="update_password" class="btn btn-outline-info bttn">
        Update Password
    </button>
					</div>
				</div>
		  </div>
	   </div>
  </div>
</form>

@endsection
@section('js')
<script>
   function triggerFileInput() {
        document.getElementById('profilePicture').click();
    }

    function displayImage(input) {
        var preview = document.getElementById('profileDisplay');
        var defaultImage = document.getElementById('displayImage');

        if (input.files && input.files[0]) {
            var reader = new FileReader();

            reader.onload = function (e) {
                preview.src = e.target.result;
                preview.style.display = 'block'; // Display the preview
                defaultImage.style.display = 'none'; // Hide the default image
            };

            reader.readAsDataURL(input.files[0]);
        }
    }
    function readURL() {
        var fileInput = document.getElementById('profilePicture');
        var file = fileInput.files[0];
        var errorElement = document.getElementById('file-error');
        var previewElement = document.getElementById('imagePreview');
    
        // Clear previous error and hide the preview initially
        errorElement.textContent = "";
        previewElement.style.display = "none";
    
        if (file) {
            // Validate file size (max 1MB)
            if (file.size > 1048576) { // 1MB in bytes
                errorElement.textContent = "File size must be less than or equal to 1MB.";
                fileInput.value = ""; // Clear the input
                return;
            }
    
            // Show image preview
            var reader = new FileReader();
            reader.onload = function (e) {
                previewElement.src = e.target.result;
                previewElement.style.display = "block";
            };
            reader.readAsDataURL(file);
        }
    }

        
</script>

@endsection
